<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_PlayableLocations_GoogleMapsPlayablelocationsV3LogPlayerReportsRequest extends Google_Collection
{
  protected $collection_key = 'playerReports';
  protected $clientInfoType = 'Google_Service_PlayableLocations_GoogleMapsUnityClientInfo';
  protected $clientInfoDataType = '';
  protected $playerReportsType = 'Google_Service_PlayableLocations_GoogleMapsPlayablelocationsV3PlayerReport';
  protected $playerReportsDataType = 'array';
  public $requestId;

  /**
   * @param Google_Service_PlayableLocations_GoogleMapsUnityClientInfo
   */
  public function setClientInfo(Google_Service_PlayableLocations_GoogleMapsUnityClientInfo $clientInfo)
  {
    $this->clientInfo = $clientInfo;
  }
  /**
   * @return Google_Service_PlayableLocations_GoogleMapsUnityClientInfo
   */
  public function getClientInfo()
  {
    return $this->clientInfo;
  }
  /**
   * @param Google_Service_PlayableLocations_GoogleMapsPlayablelocationsV3PlayerReport
   */
  public function setPlayerReports($playerReports)
  {
    $this->playerReports = $playerReports;
  }
  /**
   * @return Google_Service_PlayableLocations_GoogleMapsPlayablelocationsV3PlayerReport
   */
  public function getPlayerReports()
  {
    return $this->playerReports;
  }
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  public function getRequestId()
  {
    return $this->requestId;
  }
}
